import cv2
from ControllerMapping import Buttons
from Macro import Macro
from ScriptCore import Template, PrintColors
import random

class Script(Template):
    def __init__(self, controller, report):
        super().__init__(controller, report)

        self.auto_sprint = Macro(controller, [
            [self.press_button, Buttons.BTN_LEFT_THUMB],
            ["wait_random", 50, 150],
            [self.release_button, Buttons.BTN_LEFT_THUMB],
            ["wait_random", 50, 150],
        ])

        self.bunny_hop = Macro(controller, [
            [self.release_button, Buttons.BTN_SOUTH],
            ["wait_random", 50, 150],
            [self.press_button, Buttons.BTN_SOUTH],
            ["wait_random", 50, 150],
            [self.release_button, Buttons.BTN_SOUTH]
        ])

        self.auto_melee = Macro(controller, [
            [self.release_button, Buttons.BTN_RIGHT_THUMB],
            ["wait_random", 50, 150],
            [self.press_button, Buttons.BTN_RIGHT_THUMB],
            ["wait_random", 50, 150],
            [self.release_button, Buttons.BTN_RIGHT_THUMB]
        ])

        self.auto_ping = Macro(controller, [
            ["wait_random", 250, 500],
            [self.release_dpad_button, Buttons.BTN_DPAD_UP],
            ["wait_random", 50, 150],
            [self.press_dpad_button, Buttons.BTN_DPAD_UP],
            ["wait_random", 50, 150],
            [self.release_dpad_button, Buttons.BTN_DPAD_UP],
            ["wait_random", 50, 150],
            [self.press_dpad_button, Buttons.BTN_DPAD_UP],
            ["wait_random", 50, 150],
            [self.release_dpad_button, Buttons.BTN_DPAD_UP],
            ['wait', 2000]
        ])

        self.rapid_fire = Macro(controller, [
            [self.right_trigger_float, 0],
            ["wait_random", 50, 150],
            [self.right_trigger_float, 1],
            ["wait_random", 50, 150],
            [self.right_trigger_float, 0],
        ])

        self.strafe_ads = Macro(controller, [
            [self.left_joystick_float, [-1, 0]],
            ["wait_random", 300, 400],
            [self.left_joystick_float, [1, 0]],
            ["wait_random", 300, 400],
            [self.left_joystick_float, [0, 0]],
        ])

    def run(self, frame):
        
        if (self.get_setting('ads_strafe')):
            # Strafe ADS
            if (self.get_actual_left_trigger() > 0.01 and abs(self.get_actual_left_stick_x()) < 0.10 and abs(self.get_actual_left_stick_y()) < 0.10):
                self.strafe_ads.run()
            else:
                self.strafe_ads.stop()

        if (self.get_setting('auto_sprint')):
            # Auto Sprint
            if (self.get_actual_left_stick_y() < -0.80 and not self.is_actual_button_pressed(Buttons.BTN_LEFT_THUMB)):
                self.auto_sprint.run()

        if (self.get_setting('hair_trigger')):
            # Hair trigger left
            if (self.get_actual_left_trigger() > 0.01):
                self.left_trigger_float(1)

            # Hair trigger right
            if (self.get_actual_right_trigger() > 0.01 and self.rapid_fire.isStopped()):
                self.right_trigger_float(1)

        if (self.get_setting('bunny_hop')):
            # Bunny Hop
            if (self.is_actual_button_pressed(Buttons.BTN_SOUTH)):
                self.bunny_hop.run()

        if (self.get_setting('auto_melee')):
            # Auto Melee 
            if (self.is_actual_button_pressed(Buttons.BTN_RIGHT_THUMB)):
                self.auto_melee.run()

        if (self.get_setting('auto_ping')):
            # Auto Ping
            if (self.get_actual_right_trigger() > 0.01):
                self.auto_ping.run()

        if (self.get_setting('rapid_fire')):
            # Rapid Fire
            if (self.get_actual_right_trigger() > 0.01):
                self.rapid_fire.run()

        self.auto_sprint.cycle()
        self.bunny_hop.cycle()
        self.auto_melee.cycle()
        self.auto_ping.cycle()
        self.rapid_fire.cycle()
        self.strafe_ads.cycle()

        return frame

