import cv2
from ControllerMapping import Buttons
from Macro import Macro
from ScriptCore import Template, PrintColors
from Config import Config
import numpy as np
import random
import time

class Script(Template):

    def __init__(self, controller, report):
        super().__init__(controller, report)
        
        self.enabled = True
        self.recoilVal = 0
        self.diviationX = 0
        self.angle = 0
        
    def run(self, frame):
        currentRX = self.get_actual_right_stick_x()
        currentRY = self.get_actual_right_stick_y()

        # Toggle recoil
        if (self.get_actual_left_trigger() and self.is_actual_button_pressed(Buttons.BTN_RIGHT_THUMB) and self.is_actual_button_pressed(Buttons.BTN_DPAD_DOWN)):
            if (self.enabled):
                self.enabled = False
                self.print_log("Recoil disabled", PrintColors.COLOR_RED)
                time.sleep(0.5)
            else:
                self.enabled = True
                self.print_log("Recoil enabled", PrintColors.COLOR_GREEN)
                time.sleep(0.5)

        if (self.enabled == False):
            self.right_joystick_float(currentRX, currentRY)
            return frame
        
        recoilStrength = float(self.get_setting('strength'))
        maxRecoil = float(self.get_setting('max_strength'))
        deadzone = float(self.get_setting('deadzone'))
        stabliser = float(self.get_setting('stabliser'))

        # Activate recoil
        if (self.get_actual_left_trigger() and self.get_actual_right_trigger()):
            recoilStrength = (recoilStrength / 1000)
            deviationStrenth = (float(self.get_setting('randomisation')) / 100)

            if (currentRY < -recoilStrength and currentRY < self.recoilVal):
                self.recoilVal = currentRY
            else:
                self.recoilVal -= recoilStrength
                self.diviationX -= random.uniform(-deviationStrenth, deviationStrenth)

                if (self.recoilVal < -maxRecoil):
                    self.diviationX = 0 + np.clip(np.sin(time.time() * 25), -1, 1) * stabliser
                    self.recoilVal = -maxRecoil
                
                    self.angle += 1 * stabliser
        else:
            self.recoilVal = 0
            self.diviationX = 0

        # Don't apply recoil if right stick is pushed upward
        if (currentRY > maxRecoil):
            self.right_joystick_float(currentRX, currentRY)
        else:
            self.right_joystick_float(np.clip(currentRX + self.diviationX, -1, 1), np.clip(currentRY + self.recoilVal + -deadzone, -1, 1))

        return frame

